/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.gui;

import java.text.DecimalFormat;
import java.util.function.Supplier;
import meldexun.entityculling.gui.IConfigWidget;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigSlider
extends AbstractSlider
implements IConfigWidget {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private final ForgeConfigSpec.ConfigValue<? extends Number> config;
    private final double min;
    private final double max;
    private final double stepSize;

    public ConfigSlider(int x, int y, int width, int height, ForgeConfigSpec.IntValue config, int min, int max, int stepSize) {
        super(x, y, width, height, ConfigSlider.getText((ForgeConfigSpec.ConfigValue<? extends Number>)config, ((Integer)config.get()).intValue()), (double)(((Integer)config.get() - min) / (max - min)));
        this.config = config;
        this.min = min;
        this.max = max;
        this.stepSize = stepSize;
    }

    public ConfigSlider(int x, int y, int width, int height, ForgeConfigSpec.DoubleValue config, double min, double max, double stepSize) {
        super(x, y, width, height, ConfigSlider.getText((ForgeConfigSpec.ConfigValue<? extends Number>)config, (Double)config.get()), ((Double)config.get() - min) / (max - min));
        this.config = config;
        this.min = min;
        this.max = max;
        this.stepSize = stepSize;
    }

    public static ITextComponent getText(ForgeConfigSpec.ConfigValue<? extends Number> config, double value) {
        return new TranslationTextComponent((String)config.getPath().get(config.getPath().size() - 1), new Object[]{TextFormatting.GRAY.toString() + FORMAT.format(value)});
    }

    protected void func_230979_b_() {
        double d = this.min + this.stepSize * (double)Math.round(this.field_230683_b_ * (this.max - this.min) / this.stepSize);
        this.func_238482_a_(ConfigSlider.getText(this.config, d));
    }

    protected void func_230972_a_() {
    }

    @Override
    public void updateConfig() {
        if (this.config instanceof ForgeConfigSpec.IntValue) {
            ((ForgeConfigSpec.IntValue)this.config).set((Object)((int)(this.min + this.stepSize * (double)Math.round(this.field_230683_b_ * (this.max - this.min) / this.stepSize))));
        } else if (this.config instanceof ForgeConfigSpec.DoubleValue) {
            ((ForgeConfigSpec.DoubleValue)this.config).set((Object)(this.min + this.stepSize * (double)Math.round(this.field_230683_b_ * (this.max - this.min) / this.stepSize)));
        }
    }

    @Override
    public void resetConfigWidget() {
        if (this.config instanceof ForgeConfigSpec.IntValue) {
            ((ForgeConfigSpec.IntValue)this.config).set((Object)((Integer)((Supplier)CONFIG_VALUE_DEFAULT_SUPPLIER.get(this.config)).get()));
        } else if (this.config instanceof ForgeConfigSpec.DoubleValue) {
            ((ForgeConfigSpec.DoubleValue)this.config).set((Object)((Double)((Supplier)CONFIG_VALUE_DEFAULT_SUPPLIER.get(this.config)).get()));
        }
        this.field_230683_b_ = (Double)this.config.get();
        this.func_238482_a_(ConfigSlider.getText(this.config, this.field_230683_b_));
    }
}

